/*global jQuery */
window.actualversion = "4";
/* Defend prototype.js incombabilities */
jQuery.noConflict();
/* set document.domain for live server */
if(window.location.href.search(/zeit\.de/) > -1) document.domain = "zeit.de";
var ord = Math.random() * 10000000000000000;
/* lousy browser detection pattern */
window.myagent = navigator.userAgent||navigator.vendor||window.opera;
window.mygrep = /android|avantgo|blackberry|blazer|compal|elaine|fennec|hiptop|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|o2|opera mini|palm( os)?|plucker|pocket|pre\/|psp|smartphone|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce; (iemobile|ppc)|xiino/i;
/* detect Tablets */
window.is_iPad = navigator.userAgent.match(/iPad/i) !== null;
window.is_galaxyTab = navigator.userAgent.match(/GT-P1000/i) !== null  || navigator.userAgent.match(/HTC_Flyer/i) !== null ;
window.is_Flyer = navigator.userAgent.match(/HTC_Flyer/i) !== null;
window.is_tablet = ( navigator.userAgent.match(/iPad/i) !== null || navigator.userAgent.match(/GT-P1000/i) !== null || navigator.userAgent.match(/HTC_Flyer/i) !== null );
window.is_touchable = !!('ontouchstart' in window);
if(window.location.href.search(/premium\.zeit\.de/) > -1 || window.location.href.search(/community\.zeit\.de\/user/) > -1 ) {
	// Suppress iPadversion for premium
	window.is_iPad = false;
	window.is_galaxyTab = false;
	window.is_tablet = false;
}
/* hide firebug console from non-capable */
if (typeof window.loadFirebugConsole == "undefined" || typeof window.console == 'undefined' ) {
    var names = ["log", "debug", "info", "warn", "error", "assert", "dir", "dirxml", "group", "groupEnd", "time", "timeEnd", "count", "trace", "profile", "profileEnd"];
    window.console = {};
    for (var i = 0; i < names.length; ++i) {
        window.console[names[i]] = function(){};
    }
}

/* the ZEIT namespace */
var ZEIT = function() {
    return {
		hideEmptyAdPlace:function(place) {
			if(window.hiddenplaces==undefined) window.hiddenplaces = {};
			if(jQuery("img[src*='dot.gif']",'#'+place).size() > 0 || jQuery("img[src*='817-grey.gif']",'#'+place).size() > 0 || jQuery("img[src*='zeit_zaehlpixel_kinderzeit']",'#'+place).size() > 0) {
				jQuery('#'+place).hide();
				window.hiddenplaces[place]=true;
			} else window.hiddenplaces[place]=false;
		},
        clickIVW: function () { // loads 1 IVW-Counting Pixel
			if(window.Z_IVW_RESSORT !== undefined) 
			var click = jQuery("<img>").attr("src", 'http://zeitonl.ivwbox.de/cgi-bin/ivw/CP/'+window.Z_IVW_RESSORT+';?r='+escape(document.referrer)+'&d='+Math.random()*100000).width(1).height(1).addClass('ivw-aja-pixel');
		},
		clickWebtrekk: function (mode) { // sends a click to webtrekk via wt_sendinfo function
			if( typeof mode == 'undefined') return;
			if( window.wt !== undefined ) {
				if( window.wt.sendinfo !== undefined ) window.wt.sendinfo({linkId: mode});
			}
		},
		cookieCreate: function (name,value,days, domain) {
			if(arguments.length < 4) var domain = "zeit.de";
			var expires = "";
			if (days) {
				var date = new Date();
				date.setTime(date.getTime()+(days*24*60*60*1000));
				expires = "; expires="+date.toGMTString();
			}
			document.cookie = name+"="+value+expires+"; path=/; domain="+domain;
		},
		cookieRead: function (name) {
			var nameEQ = name + "=";
			var ca = document.cookie.split(';');
			for(var i=0;i < ca.length;i++) {
				var c = ca[i];
				while (c.charAt(0)==' ') c = c.substring(1,c.length);
				if (c.indexOf(nameEQ) === 0) return c.substring(nameEQ.length,c.length);
			}
			return null;
		},
		cookieErase: function (name) {
			ZEIT.cookieCreate(name,"",-1);
		},
		cookieSearchName: function (partofname) {
			var ca = document.cookie.split(';');
			for(var i=0;i < ca.length;i++) {
				var c = ca[i];
				while (c.charAt(0)==' ') c = c.substring(1,c.length);
				c = c.split("=");
				if(c[0].indexOf(partofname) > -1) return c[0];
			}
			return null;
		},
		crunchCookies: function () {
			if((ZEIT.cookieRead('drupal-username') === null && ZEIT.cookieRead('drupal-userid') !== null) || (ZEIT.cookieRead('drupal-username') !== null && ZEIT.cookieRead('drupal-userid') === null)) {
				var sessname = ZEIT.cookieSearchName('SESS');
				if(sessname !== null) {
					ZEIT.cookieErase(sessname);
					ZEIT.cookieErase('drupal-username');
					ZEIT.cookieErase('drupal-userid');
					ZEIT.cookieErase('drupal-useradmin');
					ZEIT.cookieErase('drupal-author');
					console.info('The Cookiemonster has crunched some cookies, yam yam.');
				}
			}
		},
		getQuery: function(query) {
			if(query !== '') {
				query = query.substring(1);
				var parms = query.split('&');
				return ZEIT.splitQuery(parms, "=");
			}
			return false;
		},
		getQueryVar: function(varname) {
			var q = ZEIT.getQuery(window.location.search);
			return q[varname] !== undefined ? q[varname] : false;
		},
		getRessort: function(){
			return $('body').attr('data-ressort') || "undefined";
		},
		logWebtrekkAppend: function(appendstring) {
			var wt_kennung = false;
			wt_kennung = window.Z_WT_KENNUNG+'.'+appendstring;
			if(wt_kennung !== false) {
				var wt_px = '<img alt="" height="1" src="http://zeit01.webtrekk.net/981949533494636/wt.pl?p=205,'+wt_kennung+'&#38;ov=&#38;cr=&#38;oi=&#38;ba=&#38;co=&#38;qn=&#38;ca=&#38;pi=&#38;st=&#38;cd=&#38;cg=&#38;zeit='+ZEIT.throwDice()+'" width="1"/>';
				jQuery("#wrapper").append(jQuery(wt_px));
			}
		},
		tabletWeiche: function() {
			if( !window.is_galaxyTab && (ZEIT.cookieRead("tabletOverride") == "tablet" || ZEIT.getQueryVar("forcetablet") == "on") ) {
				ZEIT.cookieCreate("tabletOverride", "tablet", false, "zeit.de");
				window.is_iPad = true;
				window.is_tablet = true;
				window.is_overridden_tablet = false;
			}
			if( !window.is_galaxyTab && (ZEIT.cookieRead("tabletOverride") == "desktop" || ZEIT.getQueryVar("forcetablet") == "off") ) {
				ZEIT.cookieCreate("tabletOverride", "desktop", false, "zeit.de");
				window.is_iPad = false;
				window.is_tablet = false;
				window.is_overridden_tablet = true;
			}
		},
		mobileRedirect: function() {
			var lhome, lprint, lressort;
			var confirmtext = 'Wollen Sie zur mobilen Version dieser Seite wechseln?';
			var direction = ZEIT.cookieRead('ZEITmobile');
			if(location.hostname=='zip6.zeit.de') {
				lhome = /zip6.zeit.de\/(ipad)\/index/gi;
				lprint = /zip6.zeit.de\/(ipad)\/\d{4}\/\d{2}\/[^(index)]+/gi;
				lressort = /zip6.zeit.de\/(ipad)\/(politik|wirtschaft|meinung|gesellschaft|kultur|wissen|digital|studium|karriere|lebensart|reisen|auto|sport)\/(.+)/gi;
			} else {
				lhome = /(www\.)?zeit.de\/index/gi;
				lprint = /(www\.)?zeit.de\/\d{4}\/\d{2}\/[^(index)]+/gi;
				lressort = /(www\.)?zeit.de\/(politik|wirtschaft|meinung|gesellschaft|kultur|wissen|digital|studium|karriere|lebensart|reisen|auto|sport)\/(.+)/gi;
			}
			if(document.referrer.indexOf('mobil.zeit.de') > -1) {
				direction = "";
				confirmtext = 'Sie kehren vom Mobilangebot zurueck. Wollen Sie erneut zur mobilen Version dieser Seite wechseln?';
			}
			if(lhome.test(location.href) || lprint.test(location.href) || lressort.test(location.href)) {
				if(direction == 'www') {
					return false;
				} else if(direction == 'mobile') {
					if(location.hostname=='blog.zeit.de') {
						return false;
					} else {
						ZEIT.redirect('http://mobil.zeit.de/');
					}
				} else {
					// ask for direction
					if(!confirm(confirmtext)) {
						ZEIT.cookieCreate('ZEITmobile','www',7, 'zeit.de');
						return false;
					} else {
						ZEIT.cookieCreate('ZEITmobile','mobile',7, 'zeit.de');
						if(location.hostname=='blog.zeit.de') {
							if(ZEIT.cookieRead('ZEITmobile') == 'mobile') window.location.reload();
							return false;
						} else {
							ZEIT.redirect('http://mobil.zeit.de/');
						}
					}
				}
			}
		},
		redirect: function(target) {
			try {
				if(location.hostname=='zip6.zeit.de') {
					var r = /http:\/\/(zip6\.)?zeit.de\/ipad\/(.*)/gi;
				} else {
					var r = /http:\/\/(www\.)?zeit.de\/(.*)/gi;
				}
				var d = r.exec(document.location.href);
				if(d) location.href = target + d[2];
			} catch(e) {
				console.error("redirect fail", e);
			}
		},
		splitQuery: function(parms, splitchar) {
			var qsParm = {};
			for (var i=0; i<parms.length; i++) {
				var pos = parms[i].indexOf(splitchar);
				if (pos > 0) {
					var key = parms[i].substring(0,pos);
					var val = parms[i].substring(pos+1);
					qsParm[key] = val;
				}
			}
			return qsParm;
		},
		throwDice: function() {
			return Math.random()*10000000000000000;
		},
		xmlsrc: function() {
			var r = "http://xml.zeit.de/data/navigation.xml";
			if(window.zipserver == 'zip6') {
				r = "http://zip6.zeit.de/preview-xml/data/navigation.xml";
			} else if(location.href.indexOf('zonPad') > -1) {
				r = "xml/navigation.xml";
			}
			return r;
		},
        preview: function (type) {
			if ( type === "css" ) return ZEIT.csspath();
			if ( location.href.search(/https:/) > -1 ) return "https://ssl.zeit.de/images.zeit.de/static/js/";
			if ( typeof window.js_path === "undefined")  return "http://scripts.zeit.de/static/js/";
			return window.js_path + "/";
		},
		csspath: function () {
			if ( location.href.search(/https:/) > -1 ) return "https://ssl.zeit.de/images.zeit.de/static/css/";
			if ( typeof window.css_path === "undefined") return "http://css.zeit.de/static/css/";
			return window.css_path + "/";
		}
    };
}();

ZEIT.tabletWeiche();

if(is_iPad || is_galaxyTab) {
	// load CSS
	jQuery("<link>").attr("rel", "stylesheet").attr("id", "ipad").attr("href", ZEIT.csspath()+"tablet.css?" + window.actualversion).appendTo("head");
} else {
	try {
		if(window.mygrep.test(window.myagent)) {
			if(myagent.search(/opera/gi) > -1) {
				// opera needs an onload event
				jQuery(document).ready(function(){
					ZEIT.mobileRedirect();
				});	
			} else {
				ZEIT.mobileRedirect();
			}
		}
	} catch(e) {
		console.info(e);
	}
}